<?php

/**
 * webtrees: online genealogy
 * Copyright (C) 2022 webtrees development team
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Fisharebest\Webtrees\Elements;

/**
 * TIME_VALUE := {Size=1:12}
 * [ hh:mm:ss.fs ]
 * The time of a specific event, usually a computer-timed event, where:
 * hh = hours on a 24-hour clock
 * mm = minutes
 * ss = seconds (optional)
 * fs = decimal fraction of a second (optional)
 */
class TimeValue extends AbstractElement
{
    protected const PATTERN = '([01][0-9]|2[0-3]):[0-5][0-9](:[0-5][0-9]([.][0-9]+)?)?';
}
